<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('provinces_users', function (Blueprint $table) {
            $table->foreignId('province_id')->constrained()->cascadeOnDelete(); // 
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); // 
            $table->timestamps();
            $table->primary(['province_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('provinces_users');
    }
};
